#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include <ESP32Servo.h>
#define irs       25
#define S0        5
#define S1        17
#define S2        19
#define S3        23
#define sensorOut 18
#define resetbutton 15
LiquidCrystal_I2C lcd(0x27, 20, 4);
Servo servo1;
Servo servo2;
int minUs = 1000;
int maxUs = 2000;
int servo1Pin = 32;
int servo2Pin = 33;
ESP32PWM pwm;
bool flag1 = false;
bool flag2 = false;
bool flag3 = false;
bool flag4 = false;
int counter1 = 0;
int counter2 = 0;
bool enableCounting = false;
// Calibration Values
int redMin = 153;
int redMax = 232;//+10
int greenMin = 171;
int greenMax = 260;//+10
int blueMin = 138;
int blueMax = 209;//+10

// Variables for Color Pulse Width Measurements
int redPW = 0;
int greenPW = 0;
int bluePW = 0;

// Variables for final Color values
int redValue;
int greenValue;
int blueValue;

void setup() {
  Serial.begin(9600);
  pinMode(irs, INPUT);
  pinMode(S0, OUTPUT);
  pinMode(S1, OUTPUT);
  pinMode(S2, OUTPUT);
  pinMode(S3, OUTPUT);
  pinMode(sensorOut, INPUT);
  digitalWrite(S0, HIGH);
  digitalWrite(S1, LOW);
  lcd.init();
  lcd.backlight();
  lcd.setCursor(5, 1);
  lcd.print("PROTOTYPE");
  lcd.setCursor(2, 2);
  lcd.print("PEMILAH BUAH PIR");
  delay(1500);
  ESP32PWM::allocateTimer(0);
  ESP32PWM::allocateTimer(1);
  ESP32PWM::allocateTimer(2);
  ESP32PWM::allocateTimer(3);
  servo1.setPeriodHertz(50);
  servo2.setPeriodHertz(50);
  servo1.attach(servo1Pin, minUs, maxUs);
  servo2.attach(servo2Pin, minUs, maxUs);
  servo1.write(135);//titik nol
  servo2.write(135);//titik nol
  lcd.clear();
  delay(1000);
  servo2.write(0);
  delay(1000);
  servo2.write(135);
}

void loop() {
  int resetValue = digitalRead(resetbutton);
  int hasils = digitalRead(irs);
  if (hasils == LOW && flag2 == true) {
    servo1.write(0);
    delay(2000);
    servo1.write(135);
    lcd.setCursor(10, 0);
    lcd.print("          ");
    lcd.setCursor(10, 1);
    lcd.print("    ");
    flag2 = false;
  }
  if (hasils == LOW && flag3 == true) {
    lcd.setCursor(10, 0);
    lcd.print("          ");
    lcd.setCursor(10, 1);
    lcd.print("    ");
    flag3 = false;
  }
  if (hasils == LOW && flag1 == false) {
    servo2.write(0);
    delay(500);
    servo2.write(135);
    flag1 = true;
  }
  if (hasils == HIGH) {
    flag1 = false;
  }
  redPW = getRedPW();
  redValue = map(redPW, redMin, redMax, 255, 0);
  delay(100);
  //////////////////////////////////////////////////////
  greenPW = getGreenPW();
  greenValue = map(greenPW, greenMin, greenMax, 255, 0);
  delay(100);
  //////////////////////////////////////////////////////
  bluePW = getBluePW();
  blueValue = map(bluePW, blueMin, blueMax, 255, 0);
  delay(100);
  if ((redValue > 300) && (redValue < 600) && (greenValue > 200) && (greenValue <  500) && (blueValue > 200) && (blueValue < 400) && flag3 == false)
  {
    counter2++;
    lcd.setCursor(10, 0);
    lcd.print("Buah Segar");
    lcd.setCursor(10, 1);
    lcd.print(counter2);
    flag3 = true;
  }
  else if ((redValue > 10) && (redValue < 150) && (greenValue > 10) && (greenValue <  100) && (blueValue > 10) && (blueValue < 80) && flag2 == false)
  {
    counter1++;
    lcd.setCursor(10, 0);
    lcd.print("Buah Busuk");
    lcd.setCursor(10, 1);
    lcd.print(counter1);
    flag2 = true;
  }
  else {
    lcd.setCursor(0, 0);
    lcd.print("Kondisi : ");
    lcd.setCursor(0, 1);
    lcd.print("Jumlah  : ");
  }
  lcd.setCursor(3, 2);
  lcd.print("R=");
  lcd.print(redValue);
  lcd.print(" G=");
  lcd.print(greenValue);
  lcd.print("   ");
  lcd.setCursor(5, 3);
  lcd.print(" B=");
  lcd.print(blueValue);
  lcd.print("   ");
  if (resetValue == LOW && flag4 == false) {
    lcd.clear();
    lcd.setCursor(7, 0);
    lcd.print("Total");
    lcd.setCursor(0, 1);
    lcd.print("Buah Segar: ");
    lcd.print(counter2);
    lcd.print(" Buah");
    lcd.setCursor(0, 2);
    lcd.print("Buah Busuk: ");
    lcd.print(counter1);
    lcd.print(" Buah");
    delay(3000);
    lcd.clear();
    counter1 = 0;
    counter2 = 0;
    flag4 = true;
  }
  if (resetValue == HIGH && flag4 == true) {
    flag4 = false;
  }
  delay(100);
}

int getRedPW() {
  digitalWrite(S2, LOW);
  digitalWrite(S3, LOW);
  int PW;
  PW = pulseIn(sensorOut, LOW);
  return PW;

}
int getGreenPW() {
  digitalWrite(S2, HIGH);
  digitalWrite(S3, HIGH);
  int PW;
  PW = pulseIn(sensorOut, LOW);
  return PW;

}
int getBluePW() {
  digitalWrite(S2, LOW);
  digitalWrite(S3, HIGH);
  int PW;
  PW = pulseIn(sensorOut, LOW);
  return PW;
}
